import os
import re

import requests
from flask import Flask, request

app = Flask(__name__)

@app.route('/')
def page_index():
    return page_path('')


@app.route('/<path:path>')
def page_path(path):
    url = f'http://storage:8080/{path}'
    r = requests.get(url, headers=request.headers)
    return firewall(r.text, r.headers)


# utils
def firewall(text, headers):
    with open('regex') as f:
        pattern = f.read()

    if re.search(pattern, text):
        return 'Forbidden by ' + repr(pattern)

    for v in headers.values():
        if re.search(pattern, v):
            return 'Forbidden by ' + repr(pattern)

    return text


if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8000, debug=True)
