import os
from tempfile import TemporaryDirectory
from flask import Flask, render_template, request
from utils import crack, sanitize

app = Flask(__name__)
app.config['MAX_CONTENT_LENGTH'] = 2 * 1024

@app.errorhandler(413)
def too_large(e):
    return 'Error: Too large files', 413, {'content-type': 'text/plain'}


@app.route('/', methods=['GET', 'POST'])
def index():
    if request.method == 'POST':
        zip_file = sanitize(request.files['zip'].filename)
        dict_file = sanitize(request.files['dict'].filename)

        response = 'Output:\n\n'

        with TemporaryDirectory() as path:
            request.files['zip'].save(os.path.join(path, zip_file))
            request.files['dict'].save(os.path.join(path, dict_file))
            response += crack(path, zip_file, dict_file)

        return response, 200, {'content-type': 'text/plain'}

    return render_template('index.html')


if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8000)
