from flask import Flask, render_template, url_for, request, redirect
import urllib.request

app = Flask(__name__)

@app.route('/')
@app.route('/home')
def home():
	return render_template('index.html', title='Home')

@app.route('/', methods=['POST'])
@app.route('/home', methods=['POST'])
def go_to():
	url = request.form.get('text')
	if 'localhost:8311' in url:
		return urllib.request.urlopen(url).read()
	else:
		return "https://www.youtube.com/watch?v=dQw4w9WgXcQ"

@app.route('/arena1')
def get_post1():
	return render_template('arena1.html', title='Arena 1')

@app.route('/battlezone')
def get_post2():
	return render_template('battlezone.html', title='Battlezone')

@app.route('/cybermithril')
def get_post3():
	return render_template('cybermithril.html', title='Cybermithril')

@app.route('/starforge')
def get_post4():
	return render_template('starforge.html', title='Starforge')

if __name__ == '__main__':
	app.run(host="0.0.0.0", port=8311, debug=True)
