import re
import os
import time

from flask import Flask, render_template, request
import mysql.connector

app = Flask(__name__)


def get_connection():
    config = {
        "host": os.getenv("MYSQL_HOST", "localhost"),
        "user": os.getenv("MYSQL_USER", "appuser"),
        "password": os.getenv("MYSQL_PASSWORD", "apppass"),
        "database": os.getenv("MYSQL_DB", "appdb"),
    }
    last_error = None
    for _ in range(5):
        try:
            return mysql.connector.connect(**config)
        except mysql.connector.Error as exc:
            last_error = exc
            time.sleep(1)
    raise last_error


@app.get("/")
def index():
    return render_template("login.html")


@app.post("/login")
def login():
    username = request.form.get("username", "").strip()
    password = request.form.get("password", "")

    if not waf(username):
        return render_template("login.html", error="Blocked by filter."), 401

    if not username or not password:
        return render_template("login.html", error="Missing username or password."), 400

    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute(f"SELECT id, username, password FROM users WHERE (username = '{username}')")
        row = cursor.fetchone()
    finally:
        conn.close()

    if not row:
        return render_template("login.html", error="Invalid credentials."), 401

    if row[2] != password:
        return render_template("login.html", error="Invalid credentials."), 401

    return render_template("success.html", username=username, flag=os.environ['FLAG'])


def waf(username):
    username = username.lower()
    blocked = ['union', 'char', 'and', 'sleep', 'sha1', 'md5', 'if']
    for word in blocked:
        if word in username:
            return False

    if re.match('or\s\S|\s\S', username):
        return False

    return True


if __name__ == "__main__":
    app.run(host="0.0.0.0", port=1337)
